<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* WindowsMalwareState File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;

use Microsoft\Graph\Core\Enum;

/**
* WindowsMalwareState class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class WindowsMalwareState extends Enum
{
    /**
    * The Enum WindowsMalwareState
    */
    const UNKNOWN = "unknown";
    const DETECTED = "detected";
    const CLEANED = "cleaned";
    const QUARANTINED = "quarantined";
    const REMOVED = "removed";
    const ALLOWED = "allowed";
    const BLOCKED = "blocked";
    const CLEAN_FAILED = "cleanFailed";
    const QUARANTINE_FAILED = "quarantineFailed";
    const REMOVE_FAILED = "removeFailed";
    const ALLOW_FAILED = "allowFailed";
    const ABANDONED = "abandoned";
    const BLOCK_FAILED = "blockFailed";
}
